import pandas as pd   
import pickle
from decision_company import read_csv_file, calculate_median, filter_by_condition, create_condition, logical_and, fetch_index, convert_to_list, fetch_column

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv") 
  
# Filter the clients with multiple existing credits and high installment commitments  
installment_commitment_median = calculate_median(credit_customers, 'installment_commitment')  
multiple_credits_high_commitment = filter_by_condition(high_credit_long_duration, logical_and(create_condition(fetch_column(high_credit_long_duration, 'existing_credits'), 1), create_condition(fetch_column(credit_customers, 'installment_commitment'), installment_commitment_median)))  
  
print(f"multiple_credits_high_commitment: {multiple_credits_high_commitment}")  
pickle.dump(multiple_credits_high_commitment, open("./ref_result/multiple_credits_high_commitment.pkl","wb"))

  